/* FTP.C
Test FTPAPI
Updated @ Date 28 May 1996, 13:12 by Gerrit van Niekerk
*/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include "ftpapi.h"

char *get_err(int err);
char *getsw(char *str);
char *getpar(char *ptr);
int send(FTPPar far *pf,int command,int compar);

union REGS r;
FTPPar op;		// open parameters
FTPPar com;		// command parameters

#define NUM_SESSIONS	10
int sessions[NUM_SESSIONS][2];
int current_session;

void main(/*int argc,char *argv[]*/)
{
	char buf[80],buf1[80],*p1,*p2,*p3;
	int len,session_number;

	printf("FTP test client version 2.10\n");
	if (getvect(FTP_INT) == 0) {
		printf("FTPAPI not loaded\n");
		return;
	}
	while (1) {
		getsw(buf);
		if (!*buf) {
			printf("open close exit server session dir ls get put append bin ascii ...\n");
			continue;
		}
		strcpy(buf1,buf);
		p1 = getpar(buf);
		p2 = getpar(p1);
		p3 = getpar(p2);
		getpar(p3);
		len = strlen(buf);
		if (strncmp(buf,"open",len) == 0) {
			for (session_number = 0;session_number < NUM_SESSIONS;++session_number) {
				if (sessions[session_number][0] == 0)
					break;
			}
			if (session_number == NUM_SESSIONS) {
				printf("All available sessions in use\n");
				continue;
			}
			op.par1 = p1;
			op.par2 = p2;
			op.par3 = p3;
			if (send(&op,OpenFTPSession,0) == 0) {
				sessions[session_number][0] = op.par5;
				sessions[session_number][1] = op.par6;
				current_session = session_number;
				printf("Session %d ID %04x%04x\n",current_session,
					sessions[current_session][0],sessions[current_session][1]);
			}
		}
		else if (strncmp(buf,"close",len) == 0) {
			send(&com,CloseFTPSession,0);
			sessions[current_session][0] = 0;
			for (session_number = 0;session_number < NUM_SESSIONS;++session_number) {
				if (sessions[session_number][0] != 0)
					break;
			}
			if (session_number == NUM_SESSIONS) {
				printf("All sessions closed\n");
				current_session = 0;
			}
			else {
				current_session = session_number;
				printf("Session %d ID %04x%04x\n",current_session,
					sessions[current_session][0],sessions[current_session][1]);
			}
		}
		else if (strncmp(buf,"exit",len) == 0) {
			for (current_session = 0;current_session < NUM_SESSIONS;++current_session) {
				if (sessions[current_session][0] != 0)
					send(&com,CloseFTPSession,0);
			}
			break;
		}
		else if (strncmp(buf,"server",len) == 0) {
			send(0,CallResident,XSF_STATUS);
		}
		else if (strncmp(buf,"session",len) == 0) {
			if (*p1 == 0) {
				printf("Session %d ID %04x%04x\n",current_session,
					sessions[current_session][0],sessions[current_session][1]);
				continue;
			}
			session_number = atoi(p1);
			if (session_number < NUM_SESSIONS) {
				if (sessions[session_number][0] == 0) {
					printf("Session %d is not open\n",session_number);
				}
				else {
					current_session = session_number;
					printf("Session %d ID %04x%04x\n",current_session,
						sessions[current_session][0],sessions[current_session][1]);
				}
			}
			else {
				printf("Invalid session number: %d\n",session_number);
			}
		}
		else if (strncmp(buf,"dir",len) == 0) {
			com.par4 = 1;
			goto dolist;
		}
		else if (strncmp(buf,"ls",len) == 0) {
			com.par4 = 0;
			dolist:
			com.par1 = p1;
			com.par2 = "con";
			send(&com,GetFTPDirectory,0);
		}
		else if (strncmp(buf,"get",len) == 0) {
			com.par1 = p1;
			com.par2 = p2;
			send(&com,GetFTPFile,0);
		}
		else if (strncmp(buf,"put",len) == 0) {
			com.par4 = 0;
			goto doput;
		}
		else if (strncmp(buf,"append",len) == 0) {
			com.par4 = 1;
			doput:
			com.par1 = p1;
			com.par2 = p2;
			send(&com,SendFTPFile,0);
		}
		else if (strncmp(buf,"binary",len) == 0) {
			com.par4 = 1;
			goto set;
		}
		else if (strncmp(buf,"ascii",len) == 0) {
			com.par4 = 0;
			set:
			send(&com,SetFTPType,0);
		}
		else {
			com.par1 = buf1;
			send(&com,SendFTPCommmand,0);
		}
	}
}

int send(FTPPar far *pf,int command,int compar)
{
	if (pf) {
		r.x.bx = FP_SEG(pf);
		r.x.cx = FP_OFF(pf);
		pf->par5 = sessions[current_session][0];
		pf->par6 = sessions[current_session][1];
	}
	else
		r.x.bx = r.x.cx = 0;
	r.h.ah = command;
	r.h.al = compar;
	int86(FTP_INT,&r,&r);
	if (r.x.ax)
		printf("Session %d error: %s\n",current_session,get_err(r.x.ax));
	return r.x.ax;
}

char *getpar(char *ptr)
{
	if (ptr == 0)
		return 0;
	while (*ptr) {
		if (*ptr == ' ') {
			*ptr++ = 0;
			break;
		}
		++ptr;
	}
	while (*ptr) {
		if (*ptr != ' ') {
			return ptr;
		}
		++ptr;
	}
	return 0;
}

char StatBuf[100];
FTPPar StatPar = {StatBuf};

char*	getsw(char *str)
{
	int i = 0;
	int x,y;
	char ch;

	while (1) {
		while(!kbhit()) {
			r.h.ah = CheckFTPStatus;
			r.x.bx = FP_SEG(&StatPar);
			r.x.cx = FP_OFF(&StatPar);
			int86(FTP_INT,&r,&r);
			switch (r.x.ax) {
			case 0:
				break;
			case FSTAT_LINE_RECEIVED:
				printf("%04x%04x: %s\n",StatPar.par5,StatPar.par6,StatBuf);
				break;
			case FSTAT_RX_OK:
			case FSTAT_TX_OK:
			case FSTAT_RX_ERR:
			case FSTAT_TX_ERR:
				printf("%04x%04x: Server %s: %s\n",StatPar.par5,StatPar.par6,StatBuf,get_err(r.x.ax));
				break;
			default:
				printf("%04x%04x: Status: %s\n",StatPar.par5,StatPar.par6,get_err(r.x.ax));
				break;
			}
		}
		if((ch = getch()) == 0) {
			getch();
			continue;
		}
		if (ch == '\r') {
			str[i] = 0;
			putch('\r');
			putch('\n');
			return str;
		}
		else if (ch == '\b' && i) {
			--i;
			x = wherex();
			y = wherey();
			gotoxy(--x,y);
			putch(' ');
			gotoxy(x,y);
		}
		else if (isprint(ch) && i < 79) {
			putch(ch);
			str[i++] = ch;
		}
	}
}

struct errs {
	int err;
	char *str;
};

struct errs errstr[] = {
	FSTAT_TX_ERR,"TX_ERR",
	FSTAT_RX_ERR,"RX_ERR",
	FSTAT_TX_OK,"TX_OK",
	FSTAT_RX_OK,"RX_OK",
	FSTAT_LINE_RECEIVED,"LINE_RECEIVED",
	FERR_UNKNOWN_CALL,"UNKNOWN_CALL",
	FERR_SESSION_OPEN,"SESSION_OPEN",
	FERR_SESSION_CLOSED,"SESSION_CLOSED",
	FERR_UNKNOWN_HOST,"UNKNOWN_HOST",
	FERR_NO_MEMORY,"NO_MEMORY",
	FERR_TRANSFERRING,"TRANSFERRING",
	FERR_PARAMETER_ERROR,"PARAMETER_ERROR",
	FERR_FILE_OPEN,"FILE_OPEN",
	FERR_DIR_LIST,"DIR_LIST",
	FERR_CANT_CREATE,"CANT_CREATE",
	0,""
};

char *get_err(int err)
{
	struct errs *perr;
	static char str[16];

	for (perr = errstr;perr->err;++perr) {
		if (perr->err == err)
			return perr->str;
	}
	sprintf(str,"Error %u",err);
	return str;
}
